
#ifndef _KMNG_ERROR_H
#define _KMNG_ERROR_H
 
/*! \file error.h
    \brief This file containes all KMNG error codes.          
*/

#include "KMNG_base_error.h"

#ifdef __cplusplus
extern "C"
{
#endif


/* key ring is full */
#define DX_KMNG_KEY_RING_FULL_ERR                 (DX_SEP_KMNG_KMNG_MODULE_ERROR_BASE+0x1UL)

/* illegal key id */
#define DX_KMNG_ILLEGAL_KEY_ID_ERR                (DX_SEP_KMNG_KMNG_MODULE_ERROR_BASE+0x2UL)

/* invalid entry of the key in the key ring */
#define DX_KMNG_INVALID_KEY_ENTRY_ERR             (DX_SEP_KMNG_KMNG_MODULE_ERROR_BASE+0x3UL)

/* invalid key type */
#define DX_KMNG_INVALID_KEY_TYPE_ERR              (DX_SEP_KMNG_KMNG_MODULE_ERROR_BASE+0x4UL)

/* Key password to long more than 128 bytes */
#define DX_KMNG_KEY_PASSWORD_LENGTH_ERR			  (DX_SEP_KMNG_KMNG_MODULE_ERROR_BASE+0x5UL)

/* invalid key usage */
#define DX_KMNG_INVALID_KEY_USAGE_ERR             (DX_SEP_KMNG_KMNG_MODULE_ERROR_BASE+0x6UL)

/* invalid key restriction */
#define DX_KMNG_INVALID_KEY_RESTRICTION_ERR       (DX_SEP_KMNG_KMNG_MODULE_ERROR_BASE+0x7UL)

/* invalid key size */
#define DX_KMNG_INVALID_KEY_SIZE_ERR              (DX_SEP_KMNG_KMNG_MODULE_ERROR_BASE+0x8UL)

/* AES MAC verefication of Ring Image data fail */
#define DX_KMNG_RING_IMAGE_AES_MAC_ERROR		  (DX_SEP_KMNG_KMNG_MODULE_ERROR_BASE+0x9UL)

/* General null pointer */
#define DX_KMNG_INPUT_ARG_NULL_POINTER_ERROR      (DX_SEP_KMNG_KMNG_MODULE_ERROR_BASE+0xAUL)

/* invalid length of the input buffer */
#define DX_KMNG_INVALID_BUFFER_LENGTH_ERR         (DX_SEP_KMNG_KMNG_MODULE_ERROR_BASE+0xBUL)

/* invalid key size */
#define DX_KMNG_INVALID_ASYM_KEY_COMPONENT_SIZE_ERR (DX_SEP_KMNG_KMNG_MODULE_ERROR_BASE+0xCUL)

/* non allowed key usage */
#define DX_KMNG_NON_ALLOWED_KEY_USAGE_ERR         (DX_SEP_KMNG_KMNG_MODULE_ERROR_BASE+0xDUL)

/* not valid tag for the pointed key ring */
#define KMNG_KEY_RING_CORRUPTED_ERR					(DX_SEP_KMNG_KMNG_MODULE_ERROR_BASE+0xEUL)

/* size of buffer not sufficient */
#define DX_KMNG_WRAP_KEY_BUF_SIZE_INSUFFICIENT_ERR  (DX_SEP_KMNG_KMNG_MODULE_ERROR_BASE+0xFUL)

#ifdef  __cplusplus
}
#endif


#endif /* ifndef ERROR */





